$(".js-show-sidebar, .js-close-sidebar").on("click", function() {
    $("body, aside.sidebar, .overlay").toggleClass("active");
});
$(".overlay").on("click", function() {
    $("body, aside.sidebar, .overlay").removeClass("active");
});
(function() {
    $("#switch-theme-input").on("change", function() {
        if ($(this).prop("checked")) {
            $("body").addClass("dark");
            localStorage.setItem("darkMode", true);
        } else {
            $("body").removeClass("dark");
            localStorage.setItem("darkMode", false);
        }
    });
})();
(function() {
    $(document).on("click", function(e) {
        var toggle_item = $(e.target).closest(".toggle-item"),
            toggle_head = $(e.target).closest(".toggle-head"),
            action_item = $(e.target).closest(".action-item"),
            action_head = $(e.target).closest(".action-head");
        if (action_item.length) {
            if (action_head.length && action_item.hasClass("active")) return action_item.removeClass("active");
            $(".action-item").removeClass("active");
            return action_item.toggleClass("active");
        }
        if (toggle_head.length && toggle_item.hasClass("active")) return toggle_item.removeClass("active");
        $(".toggle-item, .action-item").removeClass("active");
        toggle_item.toggleClass("active");
    });
})();

const headerScroll = () => {
    if (window.scrollY > 10) {
        document.querySelector('#header').classList.add('fixed');
    } else {
        document.querySelector('#header').classList.remove('fixed');
    }
}

document.addEventListener('DOMContentLoaded', () => {
    if (document.querySelector('#header')) {
        headerScroll();
    }
});

window.addEventListener('scroll', e => {
    headerScroll();
})

function noAuthMenu() {
		$('.b-menu-wrapper').toggleClass('active');
		$('body').toggleClass('stop-body');
}

   function searchID(){
     var service = $('#input_service').val();
     let errorSender = document.getElementById('error_search');
     var errorMsg = ` <div class="alert alert-dismissible alert-danger">
       <button type="button" class="close" data-dismiss="alert">&times;</button>
       O serviço que você está procurando não foi encontrado, tente outro ID de serviço.
    </div>`;

     try{
       var selectSerCatID = window.modules.siteOrder.services[service].cid;
       } 
       catch(err){     
         errorSender.innerHTML = errorMsg;
       }
       
       let orderCat = document.getElementById('orderform-category');
       let orderSer = document.getElementById('orderform-service');
      
 
         if(selectSerCatID){
           errorSender.innerHTML = '';
           $(function () {
             orderCat.querySelector('[selected]').removeAttribute('selected');
             console.log(selectSerCatID);
             orderCat.querySelector('[value="'+ selectSerCatID +'"]').setAttribute('selected', 'selected');
             orderCat.value = selectSerCatID;
  
             var event = document.createEvent('HTMLEvents');
             event.initEvent('change', true, false);
             orderCat.dispatchEvent(event);
             setTimeout(() => {
                   let controlSel = orderSer.querySelector('[selected]')
                   if (controlSel) {
                      controlSel.removeAttribute('selected');
                   }
                   orderSer.querySelector('[value="'+ service +'"]').setAttribute('selected', 'selected');
                   orderSer.value = service;
                   $('#serv_id').html(service);
                   orderSer.dispatchEvent(event);
  
             }, 500);
          });
         }
   }

var modalOpen = (modalId, data = null) => {
  const modal = document.getElementById(modalId);
  const modalBox = modal.querySelector('.modal-box');
  modal.classList.add('active');
  document.body.style.overflow = 'hidden';

  const closeModal = () => {
    modal.classList.remove('active');
    document.body.style.overflow = 'auto';
  }

  modal.addEventListener('click', e => {
    if (e.target !== modalBox && !modalBox.contains(e.target)) {
      closeModal();
    }
  });

  const modalCloseBtn = modal.querySelector('.m-close');
  if (modalCloseBtn) {
    modalCloseBtn.addEventListener('click', e => {
      closeModal();
    })
  }

  if (data != null) {
    Object.keys(data).forEach(key => {
      const el = document.getElementById(key);
      if (el) {
        el.innerHTML = data[key];
      }
    });
  }

}

const copyToClipboard = str => {
  const el = document.createElement('textarea');
  el.value = str;
  el.setAttribute('readonly', '');
  el.style.position = 'absolute';
  el.style.left = '-9999px';
  document.body.appendChild(el);
  el.select();
  document.execCommand('copy');
  document.body.removeChild(el);
  makeToast('Panoya kopyalandı')
};

var toastTime;

function makeToast(text = null, timeOut=4000) {
  $('.toast-text').html(text)
  $('.bs-toast').fadeIn(300);

  toastTime = setTimeout(() => {
    $('.bs-toast').fadeOut(300);
  }, timeOut);
}

function removeToast() {
  $('.bs-toast').fadeOut(300);
  clearTimeout(toastTime);
}

function setAmount(val) {
    var setamount = document.getElementById("amount");
    setamount.value = val
}

$("#orderform-service").change(function () {
    service_id = $(this).val();
    $("#s_id").text(service_id);

    description = window.modules.siteOrder.services[service_id].description
    $("#s_desc").html(description);

    name = window.modules.siteOrder.services[service_id].name
    $("#s_name").html(name);
  
    console.log($("#s_time").text());
    service_time_text = window.modules.siteOrder.services[service_id].average_time
    $("#s_time").text(service_time_text);
    $('#s_time').val($('#s_time').text());  
})

const filterServicesInput = document.getElementById('filterServicesInput');
if (filterServicesInput) {
    const serviceTitle = document.querySelectorAll('.si-title');
    const serviceHeads = document.querySelectorAll('.category-card > .card-header');
    const nothingFound = document.querySelector('.nothing-found');
    const searchTextWrite = document.getElementById('search-text-write');

    filterServicesInput.addEventListener('keyup', e => {
        const keyword = e.target.value;
        $('.service-item').each(function () {
            var text = $(this).text().toLowerCase();
            if (text.indexOf(e.target.value.toLowerCase()) == -1) {
                $(this).addClass('hidden');
            } else {
                $(this).removeClass('hidden');
            }
        });

        const catCards = document.querySelectorAll('.category-card');
        [...catCards].forEach(card => {
            const itemsHidden = card.querySelectorAll('.service-item.hidden');
            const items = card.querySelectorAll('.service-item');
            if (itemsHidden.length == items.length) {
                card.style.display = 'none';
                card.classList.add('empty');
            } else {
                card.style.display = '';
                card.classList.remove('empty');
            }
        })

        const catCardsCount = catCards.length;
        const emptyCards = document.querySelectorAll('.category-card.empty');
        console.log(emptyCards.length, catCardsCount);
        if (emptyCards.length == catCardsCount) {
            nothingFound.style.display = '';
            searchTextWrite.innerHTML = keyword;
        } else {
            nothingFound.style.display = 'none';
            searchTextWrite.innerHTML = '';
        }
    });
}

function filterService(category) {
    if (category == 'all')
        $('.category-card.hidden').removeClass('hidden');
    else {
        $('.category-card').addClass('hidden');
        $('.category-card[data-category="' + category + '"]').removeClass('hidden');
    }
    removeEmptyCategory();
}

const filterServces = document.getElementById('filterServices');
if (filterServces) {
    filterServces.addEventListener('change', e => {
        filterService(e.target.value);
    });
}

const newsDrawer = document.querySelector('.basket-drawer');

if (newsDrawer) {
  const newsDrawerToggle = document.querySelector('.basket-drawer-toggle');
  const newsDrawerClose = document.querySelector('.basket-header-close');
  const newsDrawerOverlay = document.querySelector('.basket-overlay');


  newsDrawerToggle.addEventListener('click', e => {
    newsDrawer.style.display = 'block';
    setTimeout(() => { 
      newsDrawer.style.transform = 'translateX(0)';
    }, 10)
    newsDrawerOverlay.style.display = 'block';
  });

  newsDrawerClose.addEventListener('click', e => {
    newsDrawer.style.transform = 'translateX(100%)';
    setTimeout(() => {
      newsDrawer.style.display = 'none';
    }, 300);
    newsDrawerOverlay.style.display = 'none';
  });
}

const useState = (defaultValue) => {
  let value = defaultValue;
  const getValue = () => value
  const setValue = newValue => value = newValue
  return [getValue, setValue];
}

const [gender, setGender] = useState('male');
const genderLocal = localStorage.getItem('gender');

if (genderLocal !== null) {
  setGender(genderLocal);
}

if (localStorage.getItem("color")) {
    $("body").attr("data-color", localStorage.getItem("color"));
} else {
    $("body").attr("data-color", "purple");
}

const genderSwitch = document.getElementById('gender-switch');
if (genderSwitch) {
  if (gender() == 'male') {
    genderSwitch.classList.add('gs-male');
  } else {
    genderSwitch.classList.add('gs-female');
  }
  genderSwitch.addEventListener('click', e => {
    if (gender() == 'male') {
      genderSwitch.classList.remove('gs-male');
      genderSwitch.classList.add('gs-female');
      setGender('female');
   	  localStorage.setItem("color", "purple");
      $("body").attr("data-color", "purple");
    } else {
      genderSwitch.classList.remove('gs-female');
      genderSwitch.classList.add('gs-male');
      setGender('male');
      localStorage.setItem("color", "blue");
      $("body").attr("data-color", "blue");
    }
    
    localStorage.setItem('gender', gender());
  });
}

var sChatBody = document.getElementsByClassName('schat-chat-body')[0];
if (sChatBody) {
  sChatBody.scrollTo(0, sChatBody.offsetHeight);
}

$('.home-ss-tab').click(function(){
  if($(this).hasClass('active')){
      $(this).find('.ss-tab-content').slideToggle(200);
      $(this).toggleClass('active');
  }else {
      $('.home-ss-tab').removeClass('active');
      $('.home-ss-tab > .ss-tab-content').slideUp(200);
      $(this).find('.ss-tab-content').slideToggle(200);
      $(this).toggleClass('active');
  }
});

$( "#method" ).change(function() {
        if ($(this).val() == "76268") {
            $("#pix-tab").addClass("active");
            $("#picpay-tab").removeClass("active");
            $("#crypto-tab").removeClass("active");
            $("#pmoney-tab").removeClass("active");
            $("#pix").addClass("show active");
            $("#picpay").removeClass("show active");
            $("#crypto").removeClass("show active");
            $("#pmoney").removeClass("show active");
        } else if ($(this).val() == "43134") {
            $("#pix-tab").removeClass("active");
            $("#picpay-tab").addClass("active");
            $("#crypto-tab").removeClass("active");
            $("#pmoney-tab").removeClass("active");
            $("#pix").removeClass("show active");
            $("#picpay").addClass("show active");
            $("#crypto").removeClass("show active");
            $("#pmoney").removeClass("show active");
        } else if ($(this).val() == "42637") {
            $("#pix-tab").removeClass("active");
            $("#picpay-tab").removeClass("active");
            $("#crypto-tab").addClass("active");
            $("#pmoney-tab").removeClass("active");
            $("#pix").removeClass("show active");
            $("#picpay").removeClass("show active");
            $("#crypto").addClass("show active");
            $("#pmoney").removeClass("show active");
        } else if ($(this).val() == "84495") {
            $("#pix-tab").removeClass("active");
            $("#picpay-tab").removeClass("active");
            $("#crypto-tab").removeClass("active");
            $("#pmoney-tab").addClass("active");
            $("#pix").removeClass("show active");
            $("#picpay").removeClass("show active");
            $("#crypto").removeClass("show active");
            $("#pmoney").addClass("show active");
        } else if ($(this).val() == "90121") {
            $("#pix-tab").addClass("active");
            $("#picpay-tab").removeClass("active");
            $("#crypto-tab").removeClass("active");
            $("#pmoney-tab").removeClass("active");
            $("#pix").addClass("show active");
            $("#picpay").removeClass("show active");
            $("#crypto").removeClass("show active");
            $("#pmoney").removeClass("show active");
        }
});

  
function norServices() {
    var app = document.getElementsByTagName("BODY")[0];
    localStorage.platMode = "slistTwo";
    app.classList.add('slistTwo');
    app.classList.remove('slistOne');
    console.log("platMode = " + localStorage.platMode);
}
function devServices() {
    var app = document.getElementsByTagName("BODY")[0];
    localStorage.platMode = "slistOne";
    app.classList.add('slistOne');
    app.classList.remove('slistTwo');
    console.log("platMode = " + localStorage.platMode);
}

setTimeout(function () {
    let icon = $("html select#orderform-service").find("option:selected").attr("data-icon");
    $("select#orderform-service option").attr("data-icon", icon);
    $("select#orderform-service").trigger("change");
}, 100);

$("select#orderform-platform").change(function () {
    let val = $(this).val().replaceAll(' ', '').replaceAll('\n', '').replaceAll('\r', '');
    $(".nwo-cat-btn[data-change-cat='" + val + "']").click();
	$('.nCategory').attr("style", "display:block!important");
    setTimeout(function () {
        let icon = $("select#orderform-service").find("option:selected").attr("data-icon");
        $("select#orderform-service option").attr("data-icon", icon);
        $("select#orderform-service").trigger("change");
    }, 10);
 
});

 $("select#orderform-category").change(function () {
      $('.nServices').attr("style", "display:block!important");
  });

const htmlcontents = document.querySelector("BODY");
function colorApp() {
    let mode = localStorage.getItem('platMode');
    if (mode) {
        htmlcontents.classList.toggle(localStorage.getItem('platMode'));
    }
}
colorApp();

const newOrderCats = document.getElementById('new-order-cats');

if (newOrderCats) {
    const orderFormCats = document.getElementById('orderform-category');
    var realData = orderFormCats.innerHTML;

    const dCatBtns = document.querySelectorAll('.nwo-cat-btn');
    if (dCatBtns[0]) {
        [...dCatBtns].forEach(btn => {
            btn.addEventListener('click', e => {
                const val = btn.getAttribute('data-change-cat');
                const orderFormCats = document.getElementById('orderform-category');
                const options = document.querySelectorAll('#orderform-category-copy option');

                const dCatbtns = document.querySelectorAll('.nwo-cat-btn');
                [...dCatbtns].forEach(bt => {
                    bt.classList.remove('active');
                });
                btn.classList.add('active');

                const newOptions = [];
                [...options].forEach(el => {
                    if (el.innerText.toLowerCase().includes(val.toLowerCase())) {
                        newOptions.push(el);
                    }
                });
                const newOptionsHtml = [];
                [...newOptions].forEach(el => {
                    newOptionsHtml.push(el.outerHTML);
                });
                orderFormCats.innerHTML = newOptionsHtml.join('');

                $('#orderform-category').trigger('change');
            });
        })
    }
    setTimeout(() => {
        const orderFormCopy = document.createElement('select');
        orderFormCopy.setAttribute('id', 'orderform-category-copy');
        orderFormCopy.style.display = 'none';
        orderFormCopy.innerHTML = realData;
        orderFormCats.parentNode.insertBefore(orderFormCopy, orderFormCats);
    }, 100)
}



var txid = ''

function genCode() {
  let clipboardQRCode = document.querySelector('#clipboardQRCode')
  let imgQrCodeCob = document.querySelector("#imgQrCodeCob");
  let textQRCode = document.querySelector('#textQRCode')
  let setValueCob = document.querySelector('#setValueCob')
  const user = document.querySelector('#user').textContent.trim()
  
  textQRCode.style.display = "none"
  clipboardQRCode.style.display = "none"
  imgQrCodeCob.style.width = "10%"
  imgQrCodeCob.src = "https://olaargentina.com/wp-content/uploads/2019/11/loading-gif-transparent-10.gif"

  console.log(setValueCob.value)
  fetch('https://api.bombarnasredes.xyz/cob', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json'
  },
  body: JSON.stringify({
    user: user,
    value: parseFloat(setValueCob.value).toFixed(2)
  })
})
.then(response => response.json())
.then(data => {
  txid = data.txid
  var config = { method: 'GET'};
  fetch(`https://api.bombarnasredes.xyz/cob/${data.loc.id}/qrcode`,config)
  .then( response => response.json())
  .then( data => {
    let imgQrCodeCob = document.querySelector("#imgQrCodeCob");
    let clipboardQRCode = document.querySelector('#clipboardQRCode')
    let textQRCode = document.querySelector('#textQRCode')
    
    textQRCode.value = data.qrcode
    imgQrCodeCob.src = data.imagemQrcode
    imgQrCodeCob.style.width = "100%"
    textQRCode.style.display = "flex"
    clipboardQRCode.style.display = "flex"
    
    clipboardQRCode.addEventListener('click', () => {
navigator.clipboard.writeText(data.qrcode);
      setTimeout(() => {
        clipboardQRCode.innerText = "QRCode copiado!"
      }, 300)
      setTimeout(() => {
        clipboardQRCode.innerText = "Copiar QRCode"
      }, 2000)
    })
    
    setTimeout(() => {
      verifyPayment(txid)
    }, 15000)  
      
  })
}).catch(error => {
  console.error(error);
});
}

function apiPix() {
	 const getQRCode = document.querySelector('#getQRCodeCob')
	 const setValueCob = document.querySelector('#setValueCob')
  
	setValueCob.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
          	modalOpen('pixPayment')
        	genCode()
        }
    })
      getQRCode.addEventListener('click', (e) => {
        genCode()
    })
}

setTimeout(() => {
	apiPix()
}, 100)    

document.querySelector('#method').addEventListener('change', (e) => {
  if (e.target.selectedIndex === 1) {
    setTimeout(() => {
    	apiPix()
  	}, 300)    
  } else {
    setTimeout(() => {
    	apiPix()
  	}, 300)    

  }
})

function verifyPayment(txid) {
  var config = { method: 'GET'};
  fetch(`https://api.bombarnasredes.xyz/list/pix/${txid}`, config)
  .then(response => response.json())
  .then(data => {
    if (data.txid && data.txid === txid ) {
      let imgQrCodeCob = document.querySelector("#imgQrCodeCob");
      imgQrCodeCob.style.width = "50%"
      imgQrCodeCob.src = "https://loja.diarioexcel.com.br/wp-content/uploads/2021/07/loja-diario-excel-icone-paypal-pagamento-aprovado.png"
      window.location.href = "https://hiperseguidores.com.br";
      
      // setTimeout(() => {
       //  document.querySelector('#pixPayment > div > div > div.m-header > div > div.col-auto > button > i').click()
      // }, 1000)
      console.log(data)
    } else {
      setTimeout(() => {
        verifyPayment(txid)
      }, 10000)
    }
  }).catch(error => {
    console.error(error);
  });
}

function preventFormSubmit(event) {
    event.preventDefault();
  }
