<?php
function translate_text($text, $target_language)
{
    $source_language = 'auto'; // Define o idioma de origem como automático

    // Codifica o texto para ser usado na URL da API
    $text = urlencode($text);

    // Monta a URL da API com os parâmetros necessários
    $url = "https://api.mymemory.translated.net/get?q=$text&langpair=$source_language|$target_language";

    // Faz uma chamada à API do MyMemory
    $response = file_get_contents($url);

    // Decodifica a resposta JSON
    $translation = json_decode($response, true);

    // Obtém a tradução do texto
    if (isset($translation['responseData']['translatedText'])) {
        return $translation['responseData']['translatedText'];
    }

    // Caso ocorra algum erro, retorna o texto original
    return $text;
}
?>
